<?php
$url = "http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
$parts = parse_url($url);
parse_str($parts['query'], $query);
$curl = curl_init();
curl_setopt($curl, CURLOPT_URL, "https://api.gettruehelp.com/api/profile-summary/".$query['id']);
curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
$data = curl_exec($curl);
curl_close($curl);

$dataArr = json_decode($data, true);

// print_r($dataArr);
// exit;

$first_name = $dataArr['response']['user']['first_name'] ?? '';
$middle_name = $dataArr['response']['user']['middle_name'] ?? '';
$last_name = $dataArr['response']['user']['last_name'] ?? '';
$mobile = $dataArr['response']['user']['mobile'] ?? '';
$userpics = $dataArr['response']['user']['photo_url'] ?? '';
$type = $dataArr['response']['user']['type'] ?? '';
$reviews = $dataArr['response']['reviews'];
$employment = $dataArr['response']['employment'];
$employee_custom_id = $dataArr['response']['user']['employee_custom_id'] ?? '';
$employer_custom_id = $employment[0]['employer_custom_id'] ?? '';
$avrage = array();

foreach ($reviews as $key => $review) {
   $avrage[] = $review['rating'];
}

$total_reviews = $reviews ? count($reviews) : 0;
// $avrage_rating = array_sum($avrage) / $total_reviews;
$avrage_rating = 0;
$full_name = $first_name.' '.$middle_name.' '.$last_name;
$actual_link = "http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";

$verifications = $dataArr['response']['verifications'];

$verification_details = $dataArr['response']['verification_details'];

$employer = $employment[0]['b2b_company_name'] ?? '';

function change_text($str){
   if($str == 'CRC'){
      return 'Court Record';
   }
	if($str == 'EDUCATION' || $str == 'EDUCATION_VERIFICATION'){
		return 'Education';
	}
   if($str == 'AV_POSTAL' || $str == 'AV_DIGITAL' || $str == 'AV' || $str == 'AV_VERIFICATION'){
		return 'Address';
	}
   return $str;
}

 function change_text1($str){
	if($str == 'AADHAAR_VERIFICATION' || $str == 'PAN_VERIFICATION' || $str == 'DL_VERIFICATION' || $str == 'NID'){
		return 'NID';
	}
	return $str;
 }

function find_font_aw($str){
   if($str == 'EDUCATION_VERIFICATION' || $str == 'EDUCATION'){
      return '<i class="fa fa-graduation-cap" aria-hidden="true"></i>';
   }

   if($str == 'AV_PHYSICAL' || $str == 'AV_POSTAL' || $str == 'AV_DIGITAL' || $str == 'AV'){
      return '<i class="fa fa-address-card-o" aria-hidden="true"></i>';
   }

   if($str == 'AADHAAR_VERIFICATION' || $str == 'PAN_VERIFICATION' || $str == 'DL_VERIFICATION' || $str == 'NID'){
      return '<i class="fa fa-id-card" aria-hidden="true"></i>';
   }

   if($str == 'EMPLOYMENT_CHECK' || $str == 'EMPLOYMENT'){
      return '<i class="fa fa-briefcase" aria-hidden="true"></i>';
   }

   if($str == 'CRC'){
      return '<i class="fa fa-university" aria-hidden="true"></i>';
   }

   if($str == 'SELF_HEALTH_CHECK'){
		return '<i class="fa fa-heartbeat" aria-hidden="true"></i>';
	}

   return $str;
}

function color($status) {
	switch ($status) {
		case "YELLOW":
			echo "rgb(255 193 7)";
			break;
		case "GREEN":
			echo "rgb(12 175 82)";
			break;
		case "RED":
			echo "rgb(235 75 75)";
			break;
		default:
			echo "rgb(rgb 153 153 153)";
	}
}

function verification($ver,$sev)
{
	if($sev == 'RED'){

		if($ver == 'AV_PHYSICAL' || $ver == 'AV_POSTAL' || $ver == 'AV_DIGITAL'){
			echo 'Address Not Matched';
		} elseif($ver == 'AADHAAR_VERIFICATION') {
			echo 'Aadhaar Mismatch Found';
		} elseif($ver == 'PAN_VERIFICATION'){
			echo 'PAN Mismatch Found';
		} elseif($ver == 'EDUCATION_VERIFICATION'){
			echo 'Education Not Matched';
		} elseif($ver == 'CRC'){
			echo 'Criminal Record Found';
		}

	} elseif($sev == 'GREEN') {
		if($ver == 'AV_PHYSICAL' || $ver == 'AV_POSTAL' || $ver == 'AV_DIGITAL'){
			echo 'Address has been verified';
		} elseif($ver == 'AADHAAR_VERIFICATION') {
			echo 'Aadhaar has been verified';
		} elseif($ver == 'PAN_VERIFICATION'){
			echo 'PAN has been verified';
		} elseif($ver == 'EDUCATION_VERIFICATION'){
			echo 'Education has been verified';
		} elseif($ver == 'CRC'){
			echo 'No Criminal record Found';
		}
	} elseif($sev == 'YELLOW'){
		if($ver == 'AV_PHYSICAL' || $ver == 'AV_POSTAL' || $ver == 'AV_DIGITAL'){
			echo 'Address Found with possible mismatch';
		} elseif($ver == 'AADHAAR_VERIFICATION') {
			echo 'Aadhaar Found with possible mismatch';
		} elseif($ver == 'PAN_VERIFICATION'){
			echo 'PAN Found with possible mismatch';
		} elseif($ver == 'EDUCATION_VERIFICATION'){
			echo 'Education Found with possible mismatch';
		} elseif($ver == 'CRC'){
			echo 'Found possible criminal record';
		}
	} else {
		if($ver == 'AV_PHYSICAL' || $ver == 'AV_POSTAL' || $ver == 'AV_DIGITAL'){
			echo 'Address has not been verified';
		} elseif($ver == 'AADHAAR_VERIFICATION') {
			echo 'Aadhaar has not been verified';
		} elseif($ver == 'PAN_VERIFICATION'){
			echo 'PAN has not been verified';
		} elseif($ver == 'EDUCATION_VERIFICATION'){
			echo 'Education has not been verified';
		} elseif($ver == 'CRC'){
			echo 'Criminal Verification Not Done';
		}
	}
}

$vDates = array();
function reportDate($dates){
	$max = max(array_map('strtotime', $dates));
	return date('Y-m-j H:i:s', $max);
}

foreach($verification_details as $verif1){ 
	foreach($verif1 as $val1){ 
		$antecedants_data = json_decode($val1['antecedants_data']);
		$vDates[] = $antecedants_data->verification_date; 
	}
}
?>
<!DOCTYPE html>
<html>
	<head>
		<title><?php echo $full_name; ?>'s Profile Summary -- TrueHelp</title>
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<link href="https://truehelp.io/profile/css/bootstrap.css" type="text/css" rel="stylesheet">
		<link href="https://truehelp.io/profile/css/mdb.css" type="text/css" rel="stylesheet">
		<link href="https://truehelp.io/profile/css/style.css" type="text/css" rel="stylesheet">
		<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
		<link rel="preconnect" href="https://fonts.gstatic.com">
		<link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
	</head>
	<body style="background-color: rgb(14 33 56);">
		
		<div class="container">
			<div class="row logo-panel">
				<div class="col-3 col-md-3">
					<img src = "https://truehelp.io/profile/images/logo.png" class="im1">
				</div>
				<div class="col-9 col-md-9 text-right">
					<h2 class="font-weight-500"> TRUEHELP VERIFIED REPORT</h2>
					<h4 class="font-weight-500 wi">Last updated on <?php echo date('d M Y', strtotime(reportDate($vDates))); ?></h4>
				</div>			
			</div>
			<div class="my-8 py-2 col-lg-12 prof">
				<div class="col-md-12 mb-4 mb-md-0 ">
					<div class="amazon">
						<?php if(!empty($userpics) && isset($userpics)): ?>
						<img src="<?php echo $userpics; ?>" class="rounded-circle im im2" style="max-width: 165px;max-height: 165px;">
						<?php else: ?>
						<img src="http://localhost/truehelp/profile/images/photo.jpg" class="rounded-circle im im2">
						<?php endif; ?>
						<div class="amazon-content">
							<h3 class="full-bl"><?php echo $full_name ?></h3>
							<h5 class="si1 pro-wgt"><img src="http://localhost/truehelp/profile/images/steeringWheel2.png" class="img2">&nbsp <?php echo $type; ?></h5> 
							<h5 class="si1 pro-wgt"><img src="http://localhost/truehelp/profile/images/other.png" class="img2" style="max-width: 25px;">&nbsp <?php echo $employer; ?></h5> 
							<h5 class="si1 pro-wgt"><img src="http://localhost/truehelp/profile/images/phone.png" class="img2"> &nbsp+91-XXXXXX<?php echo substr($mobile, -4); ?></h5>
							<h5 class="si1 pro-wgt">Ref No. <?php echo $employer_custom_id.'-'.$employee_custom_id ?></h5>
							<!-- <h5 class="si1 shade-bl">
							<span class="star-ra">
							<span class="fa fa-star <?php echo $avrage_rating >= 1 ? 'checked' : '' ?>"></span>
							<span class="fa fa-star <?php echo $avrage_rating >= 2 ? 'checked' : '' ?>"></span>
							<span class="fa fa-star <?php echo $avrage_rating >= 3 ? 'checked' : '' ?>"></span>
							<span class="fa fa-star <?php echo $avrage_rating >= 4 ? 'checked' : '' ?>"></span>
							<span class="fa fa-star <?php echo $avrage_rating >= 5 ? 'checked' : '' ?>"></span>
							</span> <?php echo $total_reviews ?> Reviews</h5> -->
						</div>
					</div>
				</div>
				<!--At a Glance-->
				<div class="container my-3 py-4 z-depth-1 col-lg-12 con-radius">
					<section class="px-md-3 mx-md-3  text-lg-left dark-grey-text">
						<section class="at-a-glance-margin">
							<h3 class="full-bl" style="margin-bottom: 15px;">At a Glance</h3>
							<?php foreach($verifications as $verific): ?>
							<?php $severty = json_decode($verific[ 'antecedants_data']); ?>
								<a href="#<?php echo change_text1($verific['task_display_id']); ?>">
									<h5 class="re" style="color: <?php color($severty->severity) ?>; margin-bottom: 12px;">
										<?php echo find_font_aw($verific['task_display_id']); ?>
										<?php echo verification($verific['task_display_id'],$severty->severity); ?>
									</h5>
								</a>
							<?php endforeach; ?>
						</section>
					</section>
				</div>
				<?php foreach($verification_details as $key => $verif): //print_r($verif)?>
					<?php //$sev = json_decode($verif[ 'antecedants_data']); ?>
					<!--Employment verification-->
					<section class="margin-sec" id="<?php echo $key; ?>">
						<h3 style="color: #007AFF;">
							<?php echo find_font_aw($key) ?> <?php echo change_text($key); ?> Verification
							<?php //echo find_font_aw($verif['task_display_id']) . ' ' . $sev->severity ?> <?php //echo str_replace('_', ' ', change_text($verif['task_display_id'])) ?>
						</h3>
						<?php foreach($verif as $val): //print_r($val)?>
						<?php $antecedants_data = json_decode($val['antecedants_data']); //echo '<pre>'; print_r($antecedants_data); echo '</pre>'; ?>
						<?php
							$doc_num = '';
							$address = '';
							$cource_name = '';

							if($val['task_display_id'] == 'CRC' || $val['task_display_id'] == 'AV_DIGITAL' || $val['task_display_id'] == 'AV_PHYSICAL' || $val['task_display_id'] == 'AV_POSTAL'){
								$address = $antecedants_data->address->value ?? '';
								$addr_array = explode(",", $address);
								$address = end($addr_array);
							}
							
							if($val['task_display_id'] == 'EDUCATION_VERIFICATION'){
								$cource_name = $antecedants_data->cource_name->value ?? '';
							}

							if($val['task_display_id'] == 'AADHAAR_VERIFICATION'){
								$doc_num = $antecedants_data->aadhar_number->value ? 'XXXX-XXXX-'.substr($antecedants_data->aadhar_number->value, -4) : '';
							}

							if($val['task_display_id'] == 'PAN_VERIFICATION'){
								$doc_num = $antecedants_data->pan_number->value ? 'XXXXXX'.substr($antecedants_data->pan_number->value, -4) : '';
							}
						?>
						<h5 style="color: <?php color($antecedants_data->severity) ?>;">
							<div class="d-flex align-items-stretch before-cont">
								<div class="w-100">
									<?php if($address != ''): ?>
										<?php echo $address ?>
									<?php elseif($cource_name != ''): ?>
										<?php echo $cource_name ?>
									<?php else: ?>
										<?php echo ucwords(str_replace('_', ' ', change_text(strtolower($val['task_display_id'])))) ?>
									<?php endif; ?>
								</div>
								<div class="flex-grow-1 fl" style="color: <?php color($antecedants_data->severity ) ?>;">
									<?php
										if($antecedants_data->severity == 'GREEN'){
											echo 'Verified';
										} elseif($antecedants_data->severity == 'YELLOW'){
											echo 'Possible Mismatch';
										} elseif($antecedants_data->severity == 'RED'){
											echo 'Problem Found';
										}									
									?>
								</div>
							</div>
						</h5>
						<p><?php echo $doc_num ?></p>
						<?php if($antecedants_data->verification_date != ''): ?>
						<h6 class="font-weight-normal" style="margin-bottom: 18px;">
							<ref style=" color: rgb(153 153 153)">Last verified on <?php echo date('d M Y', strtotime($antecedants_data->verification_date)); ?></ref>
						</h6>
						<?php endif; ?>
					<?php endforeach; ?>
				</section>
				<hr>
				<?php endforeach; ?>
				<!--qr code and footer-->
				<center>
					<h4 class="bl">This report is computer generated and does not require a signature*</h4>
				</center>
				<hr>
				<center>
					<h4 class="blu">To get more details, visit www.gettruehelp.com or scan this QR code</h4>
				</center>
				<center>
					<img src="https://chart.googleapis.com/chart?chs=300x300&cht=qr&chl=<?php echo $url; ?>&choe=UTF-8" title="Link to Google.com" style="max-width: 250px;" class="imgqr" />
				</center>
			</div>
			<div class="termsconds">
				<div class="row">
					<div class="col-lg-9 col-xs-12 col-sm-12 text-center txt-right-full">
						<ul style="padding: 0px;">
							<li style="border-right: 2px solid #fff;">
								<a style="color: #fff !important;" target="-_blank" href="https://www.gettruehelp.com/service-agreement/">Service Agreement</a>
							</li>
							<li style="border-right: 2px solid #fff;">
								<a style="color: #fff !important;" target="_blank" href="https://www.gettruehelp.com/privacy-statement/">Terms of Use</a>
							</li>
							<li style="">
								<a style="color: #fff !important;" target="_blank" href="https://www.gettruehelp.com/privacy-statement/">Privacy Statement</a>
							</li>
						</ul>
					</div>
					<div class="col-lg-3 col-xs-12 col-sm-12 text-right">                    
						<ul style="list-style: none; display: inline-block; padding: 0px;">
							<li style="display: inline-block;">
								<a href="">
									<img src="http://localhost/truehelp/profile/images/facebook.png" class="img-fluid" style="width: 25px; margin-right: 10px;">
								</a>
							</li>
							<li style="display: inline-block;">
								<a href="">
									<img src="http://localhost/truehelp/profile/images/instagram.png" class="img-fluid" style="width: 25px; margin-right: 10px;">
								</a>
							</li>
							<li style="display: inline-block;">
								<a href="">
									<img src="http://localhost/truehelp/profile/images/twitter.png" class="img-fluid" style="width: 25px; margin-right: 10px;">
								</a>
							</li>
						</ul>
					</div>
				</div>
			</div>
		</div>
	</body>
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
	<script>
		$(document).ready(function(){
			$("a").on('click', function(event) {
				if (this.hash !== "") {
					event.preventDefault();
					var hash = this.hash;
					$('html, body').animate({
						scrollTop: $(hash).offset().top
						}, 800, function(){
						window.location.hash = hash;
					});
				}
			});
		});
	</script>
</html>