<!doctype html>
<html lang="en">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;900&display=swap" rel="stylesheet">
    <style type="text/css">
        @font-face{font-family:Roboto,sans-serif}*{font-family:Roboto,sans-serif;font-style:normal;font-weight:400}@page{size:21cm 29.7cm;margin-top:0;margin-bottom:0;margin-left:0;margin-right:0;border:1px solid #00f}body{background-color:#f3f6fc!important;position:relative;font-family:Roboto,sans-serif!important}.header-section{background-color:#0054fe}.header-section p{color:#fff;padding:0;margin:0;font-weight:100;float:right;margin-right:70px}.top-part{padding-right:5%;padding-left:5%}.header-section .top-part{padding-top:25px;padding-bottom:25px}.header-section .top-part h4{color:#fff;font-size:28px;line-height:25px;font-weight:700}.conditions h4{color:#fff;font-size:26px;font-weight:700}.header-section .top-part h6{font-size:23px;color:#fff}.header-section .processing h4{color:#31ded2;font-size:20px;font-weight:700;margin-top:17px;margin-bottom:-45px}.success-alert p{color:#2dddd2;font-size:33px;font-weight:800}.BASIC-INFO .information h1{color:#fff;font-size:25px;font-weight:400;padding:10px;border-top-right-radius:30px}.BASIC-INFO .information p{font-size:18px;font-weight:400;padding:0;margin:0}.BASIC-INFO .information h5{font-size:13px;font-weight:400;color:#a9acbe;padding:0;margin-bottom:3px}.BASIC-INFO .information span{height:1px;width:100%;display:inline-block;background-color:#d6121200;margin:0;padding:0}.BASIC-INFO .information{background-color:#a9acbe;margin-top:25px;margin-bottom:50px;border-top-right-radius:40px;border-bottom-left-radius:40px;padding-left:20px}.BASIC-INFO .basic-info p{font-size:17px;font-weight:500;margin-bottom:0}.BASIC-INFO .basic-info span{height:2px;width:100%;display:inline-block}.BASIC-INFO .basic-info h6{color:#707696;font-weight:100;margin-bottom:0;text-align:right;margin-top:1px}.PERSON{width:165px!important;height:165px!important;border-radius:50%!important;margin-top:30px!important}.verification-details{margin-top:50px}.verification-details .verification{background-color:#a9acbe;color:#090808;border-top-right-radius:40px;border-bottom-left-radius:40px;padding-left:20px}.verification h1{color:#fff;font-size:25px;font-weight:400;padding:10px;border-top-right-radius:30px}.details p{font-size:17px;font-weight:500;margin-bottom:0;margin-left:80px}.details span{height:2px;width:100%;display:inline-block}.details h6{color:#707696;font-weight:100;margin-bottom:0;text-align:right;margin-top:1px;margin-right:90px;font-size:17px}.Timeline-details{margin-top:50px}.Timeline-details .TIMELINE{background-color:#a9acbe;color:#fff;border-top-right-radius:40px;border-bottom-left-radius:40px;padding-left:20px}.TIMELINE h1{color:#fff;font-size:25px;font-weight:400;padding:10px;border-top-right-radius:30px}.Timeline-details .t-details h5{font-size:17px;font-weight:500;margin-bottom:20px;margin-left:80px}.Timeline-details .t-details p{margin-bottom:20px;margin-left:80px}.Transaction-details{margin-bottom:50px}.Transaction-details .Transaction{background-color:#a9acbe;color:#090808;border-top-right-radius:40px;border-bottom-left-radius:40px;padding-left:20px}.Transaction h1{color:#fff;font-size:25px;font-weight:400;padding:10px;border-top-right-radius:30px}.tran-details h5{font-size:17px;font-weight:500;margin-bottom:20px;margin-left:80px}.tran-details p{text-align:right}.tran-details .code{background-image:url(../image/BACKGROUND.png);background-position:center;background-size:cover;background-repeat:no-repeat}.Transaction-details .coupon{background-repeat:no-repeat;background-size:cover;background-position:center;margin-top:30px}.coupon img{padding:40px}.coupon p{font-size:17px;font-weight:400;color:#a9acbe;margin-bottom:17px}.coupon h6{font-size:17px;font-weight:700;color:#a9acbe}.coupon h4{font-size:24px;font-weight:700;color:#a9acbe;margin-bottom:20px}.Terms-Cons{background-color:#1b62fe;padding:20px}.Terms-Cons .conditions{margin-top:20px;background:0 0;margin-bottom:0}.Terms-Cons .conditions h1{color:#fff;font-size:33px;font-weight:500}.Terms-Cons .conditions span{color:#fff;font-size:13px}@media (max-width:1199px){.header-section p{margin-right:0;font-size:13px}}@media (max-width:991px){.PERSON{width:140px!important;height:140px!important;border-radius:50%!important;margin-top:30px!important}}@media (max-width:767px){.header-section .top-part h4{font-size:24px}.BASIC-INFO .basic-info p{font-size:15px;text-align:left}.BASIC-INFO .basic-info h6{font-size:15px}.PERSON{width:100px!important;height:100px!important;border-radius:50%!important;margin-top:0!important}.details p{font-size:15px;margin-left:20px}.details h6{margin-right:20px;font-size:15px}.Timeline-details .t-details h5{font-size:15px;margin-left:20px}.Timeline-details .t-details p{margin-bottom:20px;margin-left:5px;font-size:12px}.tran-details h5{font-size:15px;margin-left:20px}.tran-details p{text-align:right;font-size:15px}.coupon h4{font-size:18px;margin-top:20px}.coupon p{font-size:13px}.coupon h6{font-size:15px;margin-bottom:20px}}.basic-info{display:inline-block;border:none;background-color:#fff;padding-top:10px;margin-bottom:20px;width:100%;border-radius:15px;padding-bottom:10px;box-shadow:0 6px 22px 0 rgba(155,170,157,.5);margin-top:-125px;width:90%;margin-left:5%}.anticents-info{border:none;background-color:#fff;padding-top:10px;border-radius:15px;padding-bottom:10px;box-shadow:0 6px 22px 0 rgba(155,170,157,.5);width:90%;margin-left:5%}.status-info{border:none;background-color:#fff;padding-top:10px;margin-bottom:30px;border-radius:15px;padding-bottom:10px;box-shadow:0 6px 22px 0 rgba(155,170,157,.5);width:90%;margin-left:5%}.conditions{clear:both;display:block;width:90%;margin-left:5%}.conditions h3{font-weight:700;margin-bottom:25px;font-size:30px;color:#1b62fe}h1#tab-h1{text-align:left;padding-left:25px;color:#0054fe;font-size:20px;font-weight:700;color:#0054fe;margin-top:10px}.anticents-info{margin-top:35px}.anticents-info h4{text-align:left;padding-left:40px;font-size:16px;line-height:19px;color:#000;margin-bottom:3px}#h4{font-weight:700;font-size:14px;line-height:10px}#p{font-size:14px!important;font-weight:400;line-height:16px}#h5{font-weight:700;font-size:20px;line-height:16px;color:#0054fe}#h5-c{font-weight:700;font-size:17px;line-height:16px;color:#0054fe}.h5-d{font-weight:700;font-size:20px;line-height:16px;color:#0054fe}.anticents-info h5{padding-left:39px;color:#000;font-size:16px;line-height:18px;font-weight:600;text-align:left;margin-top:7px}.step1 a{margin-top:5px;margin-right:36px;font-size:12px;line-height:14px;font-weight:600;float:right}.fa-angle-left{font-size:60px!important;color:#fff;float:left;margin-top:8px;font-weight:700!important}.top-description h5{font-size:23px}.top-description{padding-left:45px;padding-top:12px}.top-description p{color:#000;font-size:15px;line-height:15px;text-align:left;margin-bottom:4px}.row.report-details{padding:20px 40px 9px 36px}.report-details h5{font-size:20px;font-weight:600}.report-details p{color:#a9acbe;font-size:17px;line-height:18px;text-align:left;margin-bottom:4px}.status-info .row{padding:17px 30px;padding-bottom:10px}.status-info p{color:#000;font-size:17px;line-height:20px;text-align:left;margin-bottom:-40px;padding-top:30px}.status-info h5{font-size:20px;font-weight:600}.rep-dtls h4{font-size:15px;font-weight:600;color:red}.antecedents-value{color:#6bc077}.RED_CASE{color:red}.fa{display:inline;font-style:normal;font-variant:normal;font-weight:400;font-size:14px;line-height:1;font-family:FontAwesome;font-size:inherit;text-rendering:auto;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale}td{font-size:13.5px}.pagenum:before{content:counter(page)}ul li{margin-right:10px;color:#fff;font-size:18px;font-weight:600;z-index:99999999999999}a{color:#fff;z-index:9999999999;text-decoration:none}.tc ul li{color:#000!important;font-size:11px!important;font-weight:500!important}p{font-size:14px!important;line-height:16px!important}.top-description p{font-size:17px!important;line-height:15px!important}
    </style>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css">
    <title>Postal Address Verification</title>
</head>

<body>
    <!-------Top section------->
    <div class="header-section" style="height: 235px; width: 100%;">
        <div class="top-part">
            <div class="justify-content-center align-items-center">
                <div class="col-lg-8 col-sm-8 col-8" style="margin-top: -20px; width: 65%; float: left; padding-top: 50px;">
                    <h4>Postal Address Verification</h4>
                    <h6 style="line-height: 18px; font-size: 18px;">Client: 
                        @if(!empty($employers->b2b_company_name))
                          {{ $employers->b2b_company_name }} 
                          @if(!empty($employers->b2b_brand_name))
                            ({{ $employers->b2b_brand_name }})
                          @endif
                        @else
                          {{ $employers->first_name }} {{ $employers->middle_name }} {{ $employers->last_name }}
                        @endif
                    </h6>
                </div>
                <div class="col-lg-4 col-sm-4 col-4 text-right" style="width: 34%; float: right;">
                    <!--<img src="{{ url('/reports/image/LOGO.png') }}" class="img-fluid">-->
                </div>                    
            </div>
        </div>
    </div>
    <!------------Top section ends-------->

    <!--Basic Info -->
    <div class="basic-info" style="margin-top: -70px; height: 200px;">
        <div class="row">
            <div style="margin-top: 15px; border: 0px solid #585d5c29; border-radius: 20px; overflow: hidden; margin-left: 40px; width: 170px; height: 170px">
                @if(isset($employees->photo_url))
                    <div style="height: 180px; width: 170px; overflow: hidden;border-radius: 50%;display: flex;justify-content: center;align-items: center;margin:0; padding: 0;">
                        <img src="{{ $employees->photo_url }}" style="width: 170px; height: 170px;" />
                    </div>
                @else
                    <img src="{{ url('/reports/image/PERSON.png') }}" alt="PERSON" class="" style="width: 170px; height: 170px">
                @endif
            </div>
            <div class="top-description" style="margin-left: 195px;">
                <h5 style="font-weight: bold;">{{ $employees->first_name }} {{ $employees->middle_name }} {{ $employees->last_name }}</h5>
                <p>Father's Name : {{ $employees->co_name }}</p>
                <p>Date of Birth : {{ date('d M Y', strtotime($employees->dob)) }}</p>
                <p>Gender : {{ $employees->gender == 'M' ? 'Male' : 'Female' }}</p>
                <p>Ref No : {{ $tasks->task_number }}</p>
                <p>Candidate Id : 
                    @if($employees->employee_code)
                      ({{ $employees->employee_code }})
                    @else
                      ({{ $employees->employee_custom_id }})
                    @endif
                </p>
                <p>Verified On : {{ date('d M Y', strtotime($verificationFields['antecedants_data']['verification_date'])) }}, {{ $verificationFields['antecedants_data']['verification_time'] ?? '' }}</p>
            </div>
        </div>
    </div>

    <?php

        $severity = $verificationFields['antecedants_data']['severity'] ?? '';
        
        if($severity == 'GREEN'){
            $color = '#6cc077';
            $case = 'GREEN CASE';
        } elseif($severity == 'RED'){
            $color = '#FC1102';
            $case = 'RED CASE';
        } else {            
            $color = '#FCD302';
            $case = 'YELLOW CASE';
        }
    ?>

    <div class="status-info" style="margin-top: -25px; padding-top: 25px; padding-bottom: 10px; width: 90% !important;">
        <div class="row">
            <div class="col-9">
                <h5 id="h5">Conclusion</h5>                
            </div>
            <div class="col-3 text-right rep-dtls" style="float: right;">
                <h4 id="h5-c" style="color: {{ $color }};">{{ $case }}</h4>
            </div>
            <div class="col-12">
                <p>{{ $verificationFields['antecedants_data']['conclusion'] }}</p>
            </div>
        </div>
    </div>

    <div class="anticents-info" style="margin-top: -15px; margin-bottom: 20px;">
        <div class="row">
            <div class="col-12">
                <h1 id="tab-h1">Verification Details</h1>
            </div>
            <div class="col-12" style="padding-top: 50px; padding-bottom: -40px;">
                <div style="width: 97%; padding-left: -15px !important; margin-bottom: 10px;">
                    <h4 id="h4" style="margin-bottom: -3px; font-size: 15px;">{{  $verificationFields['antecedants_data']['address']['name'] ?? '' }}</h4>
                    <span id="h5-c" style="float: right; color: 
                    @if($verificationFields['antecedants_data']['address']['match_status'] == 'MATCHED')
                        #6cc077;
                    @elseif($verificationFields['antecedants_data']['address']['match_status'] == 'UNABLE_TO_VERIFY')
                        #FC1102;
                    @else
                        #FC1102;
                    @endif
                    " class="antecedents-value {{ str_replace(' ', '_', $verificationFields['antecedants_data']['address']['match_status']) }}">{{ str_replace('_', ' ', $verificationFields['antecedants_data']['address']['match_status']) }}</span>
                    <h5 id="p">{{ $verificationFields['antecedants_data']['address']['value'] ?? '' }}</h5>
                </div>

                <div style="width: 97%; padding-left: -15px !important; margin-bottom: 10px;">
                    <h4 id="h4" style="margin-bottom: -3px; font-size: 15px;">{{  $verificationFields['antecedants_data']['verification_code']['name'] ?? '' }}</h4>
                    <span id="h5-c" style="float: right; color: 
                    @if($verificationFields['antecedants_data']['verification_code']['match_status'] == 'MATCHED')
                        #6cc077;
                    @elseif($verificationFields['antecedants_data']['verification_code']['match_status'] == 'UNABLE_TO_VERIFY')
                        #FC1102;
                    @else
                        #FC1102;
                    @endif
                    " class="antecedents-value {{ str_replace(' ', '_', $verificationFields['antecedants_data']['verification_code']['match_status']) }}">{{ str_replace('_', ' ', $verificationFields['antecedants_data']['verification_code']['match_status']) }}</span>
                    <h5 id="p">{{ $verificationFields['antecedants_data']['verification_code']['value'] ?? '' }}</h5>
                </div>

                <div style="width: 97%; padding-left: -15px !important; margin-bottom: 10px;">
                    <h4 id="h4" style="margin-bottom: -3px; font-size: 15px;">{{ $verificationFields['antecedants_data']['accommodation_status']['name'] ?? '' }}</h4>
                    <h5 id="p">{{ $verificationFields['antecedants_data']['accommodation_status']['value'] ?? '' }}</h5>
                </div>

                <div style="width: 97%; padding-left: -15px !important; margin-bottom: 10px;">
                    <h4 id="h4" style="margin-bottom: -3px; font-size: 15px;">{{  $verificationFields['antecedants_data']['duration_of_stay']['name'] ?? '' }}</h4>
                    <h5 id="p">{{ $verificationFields['antecedants_data']['duration_of_stay']['value'] ?? '' }}</h5>
                </div>

                <div style="width: 97%; padding-left: -15px !important; margin-bottom: 10px;">
                    <h4 id="h4" style="margin-bottom: -3px; font-size: 15px;">{{ $verificationFields['antecedants_data']['above_details']['name'] ?? '' }}</h4>
                    <h5 id="p">{{ $verificationFields['antecedants_data']['above_details']['value'] ?? '' }}</h5>
                </div>

                <div style="width: 97%; padding-left: -15px !important; margin-bottom: 10px;">
                    <h4 id="h4" style="margin-bottom: -3px; font-size: 15px;">{{ $verificationFields['antecedants_data']['relationship']['name'] ?? '' }}</h4>
                    <h5 id="p">{{ $verificationFields['antecedants_data']['relationship']['value'] ?? '' }}</h5>
                </div>

                <div style="width: 97%; padding-left: -15px !important; margin-bottom: 10px;">
                    <h4 id="h4" style="margin-bottom: -3px; font-size: 15px;">{{ $verificationFields['antecedants_data']['contact_number']['name'] ?? '' }}</h4>
                    <h5 id="p">{{ $verificationFields['antecedants_data']['contact_number']['value'] ?? '' }}</h5>
                </div>

                <div style="width: 97%; padding-left: -15px !important; margin-bottom: 10px;">
                    <h4 id="h4" style="margin-bottom: -3px; font-size: 15px;">{{ $verificationFields['antecedants_data']['remarks']['name'] ?? '' }}</h4>
                    <h5 id="p">{{ $verificationFields['antecedants_data']['remarks']['value'] ?? '' }}</h5>
                </div>

            </div>
        </div>
    </div>

    @include('templates.pagefooter')

    @if($taskhistorydocs)

        @foreach($taskhistorydocs as $taskhistorydoc)

            <div style="clear: both;"></div>

            <div class="image-files" style="height: 28.7cm; width: 20cm; margin-left: 20px;">
                <img src="{{ $taskhistorydoc->document_url }}" style="height: 28.7cm; width: 20cm; text-align: center; ">
            </div>
            @include('templates.pagefooter') 
        @endforeach

    @endif

    {{-- @include('templates.terms')
    
    @include('templates.pagefooter') --}}
</body>
</html>